#ifndef __TCommunity__
#define __TCommunity__

/////////////////////////////////////////////////
// Includes
#include "stdafx.h"

class TCommunity{
public:
	static void GetRelativeComplement(const THashSet<TInt> &A, const THashSet<TInt> &B, THashSet<TInt> &Complement);
	static void GetIntersection(const THashSet<TInt> &A, const THashSet<TInt> &B, THashSet<TInt> &C);
	static int Intersection(const THashSet<TInt> &A, const THashSet<TInt> &B);
private:
	void GetNbhs(int NId, THashSet<TInt> &Nbhs) const;
	int GetNodeIdWithMaxDeg(const THashSet<TInt> &Set) const;
	int MaxNbhsInCANDNodeId(const THashSet<TInt> &SUBG, const THashSet<TInt> &CAND) const;
private:
	void Expand(const THashSet<TInt> &SUBG, THashSet<TInt> &CAND);
public:
	void GetMaximalCliques(const PUNGraph &G, int MinMaxCliqueSize, TVec<TIntV> &MaxCliques);
	static void CalculateOverlapMtr(const TVec<TIntV> &MaxCliques, int MinMaxCliqueSize, TVec<TIntV> &overlapMtr);
	static void GetCommunities(const TVec<TIntV> &overlapMtr, int NumOfOverlapingNodes, TVec<TIntV> &Communities);
	static void GetCommunities(const TVec<TIntV> &MaxCliques, const TVec<TIntV> &overlapMtr, double Treshold, TVec<TIntV> &Communities);
private: //Recursion variables only
	PUNGraph m_G;
	TIntV m_Q;
	TVec<TIntV> *m_maxCliques;
	int m_minMaxCliqueSize;
};

#endif