#include "stdafx.h"

int main(int argc, char* argv[]) {
  Env = TEnv(argc, argv, TNotify::StdNotify);
  Env.PrepArgs(TStr::Fmt("Node Centrality. build: %s, %s. Time: %s", __TIME__, __DATE__, TExeTm::GetCurTm()));
  TExeTm ExeTm;
  Try
  const TStr InFNm = Env.GetIfArgPrefixStr("-i:", "graph.txt", "Input undirected graph");
  const TStr OutFNm = Env.GetIfArgPrefixStr("-o:", "node_centrality.tab", "Output file");
  
  printf("Loading %s...", InFNm.CStr());
  PUNGraph Graph = TSnap::LoadEdgeList<PUNGraph>(InFNm);
  //PUNGraph Graph = TSnap::GenRndGnm<PUNGraph>(500, 2000);
  printf("nodes:%d  edges:%d\n", Graph->GetNodes(), Graph->GetEdges());
  FILE *F = fopen(OutFNm.CStr(), "wt");
  fprintf(F,"#File: %s\n",OutFNm());
  fprintf(F,"#Nodes: %d\tEdges: %d\n", Graph->GetNodes(), Graph->GetEdges());
  fprintf(F,"#NodeId\tDegree\tCloseness\tBetweennes\tEigenVector\tPageRank\n");
  
  TIntFltH BtwH, EigH, PRankH;
  TSnap::GetBetweennessCentr(Graph, BtwH, 1.0);
  TSnap::GetEigenVectorCentr(Graph, EigH);
  TSnap::GetPageRank(Graph, PRankH, 0.15);
  for (TUNGraph::TNodeI NI = Graph->BegNI(); NI < Graph->EndNI(); NI++) {    
    const int NId = NI.GetId();
    const double DegCentr = TSnap::GetDegreeCentr(Graph, NId);
    const double CloCentr = TSnap::GetClosenessCentr(Graph, NId);
    const double BtwCentr = BtwH.GetDat(NId);
    const double EigCentr = EigH.GetDat(NId);
    const double PgrCentr = PRankH.GetDat(NId);
    fprintf(F, "%d\t%f\t%f\t%f\t%f\t%f\n", NId, DegCentr, CloCentr, BtwCentr, EigCentr, PgrCentr);
  }
  fclose(F);

  Catch
  printf("\nrun time: %s (%s)\n", ExeTm.GetTmStr(), TSecTm::GetCurTm().GetTmStr().CStr());
  return 0;
}
